package music;

/**
 * Write a description of class Album here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.text.SimpleDateFormat;

public class Album {
    
    private String title;
    protected Performer performer;
    private int year;
    private Song[] songs;
    private ArrayList<String> credits;
    private GregorianCalendar releaseDate;
    
    public Album(String title, Performer performer, int year, Song[] songs, ArrayList<String> credits,
			GregorianCalendar releaseDate) {
		super();
		this.title = title;
		this.performer = performer;
		this.year = year;
		this.songs = songs;
		this.credits = credits;
		this.releaseDate = releaseDate;
	}

	public Album(String title, Performer performer, int year, 
                    Song[] songs, ArrayList<String> credits) {
        this.title = title;
        this.performer = performer;
        this.year = year;
        this.songs = songs;
        this.credits = credits;
    }
    
    public Album(String title, Performer performer, int year, Song[] songs) {
        this.title = title;
        this.performer = performer;
        this.year = year;
        this.songs = songs;
    }
    
    public Album(String title, Performer performer, int year, int noOfSongs) {
        this.title = title;
        this.performer = performer;
        this.year = year;
        // this.songs = songs;
        this.songs = new Song[noOfSongs];
        for (int i = 0; i < noOfSongs; i++) {
            songs[i] = new Song();
            songs[i].setTitle("Default title");
        }
    }
    
    public Album(String title, Performer performer, int year) {
        this.title = title;
        this.performer = performer;
        this.year = year;
    }
    
    public Album() {
    }
    
    @Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((credits == null) ? 0 : credits.hashCode());
		result = prime * result + ((performer == null) ? 0 : performer.hashCode());
		result = prime * result + ((releaseDate == null) ? 0 : releaseDate.hashCode());
		result = prime * result + Arrays.hashCode(songs);
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		result = prime * result + year;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Album other = (Album) obj;
		if (credits == null) {
			if (other.credits != null)
				return false;
		} else if (!credits.equals(other.credits))
			return false;
		if (performer == null) {
			if (other.performer != null)
				return false;
		} else if (!performer.equals(other.performer))
			return false;
		if (releaseDate == null) {
			if (other.releaseDate != null)
				return false;
		} else if (!releaseDate.equals(other.releaseDate))
			return false;
		if (!Arrays.equals(songs, other.songs))
			return false;
		if (title == null) {
			if (other.title != null)
				return false;
		} else if (!title.equals(other.title))
			return false;
		if (year != other.year)
			return false;
		return true;
	}

	public void display() {
    	SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        // System.out.println(this.title);
        // System.out.println(this.year);
        System.out.println("Album: " + this.title + " (" + this.year + "), " + df.format(releaseDate.getTime()));
        System.out.println("Songs: ");
        for (int i = 0; i < songs.length; i++) {
            System.out.println('\t' + songs[i].getTitle());
        }
        System.out.println("Credits: ");
        for (int i = 0; i < credits.size(); i++) {
            System.out.println('\t' + credits.get(i));
        }
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setPerformer(Performer performer) {
        this.performer = performer;
    }
    
    public Performer getPerformer() {
        return this.performer;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setSongs(Song[] songs) {
        this.songs = songs;
    }
    
    public Song[] getSongs() {
        return this.songs;
    }
    
    public void setCredits(ArrayList<String> credits) {
        this.credits = credits;
    }
    
    public ArrayList<String> getCredits() {
        return this.credits;
    }

	public GregorianCalendar getReleaseDate() {
		return releaseDate;
	}

	public void setReleaseDate(GregorianCalendar releaseDate) {
		this.releaseDate = releaseDate;
	}
    
}
